/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.dialogs;

import com.aptana.git.core.model.GitRepository;
import com.aptana.git.ui.GitUIPlugin;
import com.aptana.git.ui.dialogs.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddRemoteDialog
extends StatusDialog {
    private Text remoteURIText;
    private String remoteURI;
    private Button trackButton;
    private boolean track;
    private boolean dontAutoChangeTrack = false;
    private GitRepository repo;
    private String remoteName;
    private Text originNameText;

    public AddRemoteDialog(Shell parentShell, GitRepository repo, String remoteName, String defaultURI) {
        super(parentShell);
        this.repo = repo;
        this.remoteName = remoteName;
        this.remoteURI = defaultURI;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.AddRemoteDialog_AddRemoteDialog_Title);
    }

    protected void validateInput() {
        String newText = this.originNameText.getText();
        if (newText == null || newText.trim().length() == 0) {
            this.updateStatus((IStatus)new Status(4, GitUIPlugin.getPluginId(), Messages.AddRemoteDialog_NonEmptyRemoteNameMessage));
            return;
        }
        if (newText.trim().contains(" ") || newText.trim().contains("\t")) {
            this.updateStatus((IStatus)new Status(4, GitUIPlugin.getPluginId(), Messages.AddRemoteDialog_NoWhitespaceRemoteNameMessage));
        }
        if (this.repo.remotes().contains(newText.trim())) {
            this.updateStatus((IStatus)new Status(4, GitUIPlugin.getPluginId(), Messages.AddRemoteDialog_UniqueRemoteNameMessage));
            return;
        }
        this.updateStatus(Status.OK_STATUS);
        if (this.dontAutoChangeTrack) {
            return;
        }
        this.track = newText.equals("origin");
        this.trackButton.setSelection(this.track);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label label = new Label(composite, 64);
        label.setText(Messages.AddRemoteDialog_AddRemoteDialog_Message);
        GridData data = new GridData(1796);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
        label.setFont(parent.getFont());
        this.originNameText = new Text(composite, 2052);
        this.originNameText.setLayoutData((Object)new GridData(768));
        this.originNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddRemoteDialog.this.validateInput();
            }
        });
        label = new Label(composite, 0);
        label.setText(Messages.AddRemoteDialog_RemoteURILabel);
        this.remoteURIText = new Text(composite, 2052);
        this.remoteURIText.setText(this.remoteURI);
        this.remoteURIText.setLayoutData((Object)new GridData(768));
        this.trackButton = new Button(composite, 32);
        this.trackButton.setText(Messages.AddRemoteDialog_TrackButtonLabel);
        this.trackButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                AddRemoteDialog.this.track = AddRemoteDialog.this.trackButton.getSelection();
                AddRemoteDialog.this.dontAutoChangeTrack = true;
            }
        });
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.remoteName = this.originNameText.getText();
            this.remoteURI = this.remoteURIText.getText();
        } else {
            this.remoteName = null;
            this.remoteURI = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.originNameText.setFocus();
        if (this.remoteName != null) {
            this.originNameText.setText(this.remoteName);
            this.originNameText.selectAll();
        }
    }

    public void create() {
        super.create();
        this.validateInput();
    }

    public String getRemoteURL() {
        return this.remoteURI;
    }

    public boolean track() {
        return this.track;
    }

    public String getRemoteName() {
        return this.remoteName;
    }
}

